// Copyright 2014 Google Inc. All Rights Reserved.

#ifndef ANDROID_AUTO_PROJECTION_PROTOCOL_CORE_UTIL_SEM_H
#define ANDROID_AUTO_PROJECTION_PROTOCOL_CORE_UTIL_SEM_H

#if defined(__APPLE__) && defined(__MACH__)
#include <dispatch/dispatch.h>
#else
#include <semaphore.h>
#endif

/**
 * Wrap a semaphore. Customize this to suit the target platform & OS.
 * The android implementation uses a standard linux semaphore.
 */
class Semaphore {
public:
    Semaphore();
    Semaphore(int value);
    ~Semaphore();
    bool down();
    bool up();
private:
#if defined(__APPLE__) && defined(__MACH__)
    dispatch_semaphore_t mSem;
#else
    sem_t mSem;
#endif
};

#endif // ANDROID_AUTO_PROJECTION_PROTOCOL_CORE_UTIL_SEM_H
